/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.smartgears.extensions.ApiResource;
import org.gcube.smartgears.extensions.ApiSignature;
import org.gcube.smartgears.extensions.HttpExtension;
import org.gcube.smartgears.extensions.resource.RemoteResource;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontPageResource
extends ApiResource {
    private static Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
    private static final Logger log = LoggerFactory.getLogger(RemoteResource.class);
    private static final long serialVersionUID = 1L;
    public static final String mapping = "/";
    private static final ApiSignature signature = FrontPageResource.handles("/").with(FrontPageResource.method(HttpExtension.Method.GET).produces("application/xhtml+xml"));

    FrontPageResource() {
        super(signature);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block7: {
            InputStream page = this.getClass().getResourceAsStream("/META-INF/frontpage.html");
            if (page == null) {
                log.error("invalid distribution: missing {}", (Object)"/META-INF/frontpage.html");
                RequestError.application_error.fire("invalid distribution: missing /META-INF/frontpage.html");
            }
            Map<String, String> values = this.values();
            BufferedReader reader = null;
            try {
                try {
                    String line = null;
                    reader = new BufferedReader(new InputStreamReader(page));
                    while ((line = reader.readLine()) != null) {
                        resp.getWriter().write(FrontPageResource.interpolate(line, values));
                    }
                }
                catch (Exception e) {
                    RequestError.application_error.fire("could not read /META-INF/frontpage.html", e);
                    Utils.closeSafely(reader);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Utils.closeSafely(reader);
                throw throwable;
            }
            Utils.closeSafely(reader);
        }
    }

    private Map<String, String> values() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("profile_link", "/profile".substring(1, "/profile".length()));
        values.put("config_link", "/configuration".substring(1, "/configuration".length()));
        values.put("name", this.context().name());
        values.put("version", this.context().configuration().version());
        String infrastructure = this.context().container().configuration().infrastructure();
        StringBuilder voValue = new StringBuilder();
        Collection scopes = this.context().profile(GCoreEndpoint.class).scopes().asCollection();
        HashSet<String> vos = new HashSet<String>();
        for (String scope : scopes) {
            ScopeBean bean = new ScopeBean(scope);
            switch (bean.type()) {
                case INFRASTRUCTURE: {
                    infrastructure = bean.name();
                    break;
                }
                case VO: {
                    vos.add(bean.name());
                    break;
                }
                case VRE: {
                    vos.add(bean.enclosingScope().name());
                    infrastructure = bean.enclosingScope().enclosingScope().name();
                }
            }
        }
        int i = 0;
        int max = vos.size() - 1;
        for (String vo : vos) {
            String voPrefix = i == 0 ? "" : (i == max ? " and " : ", ");
            voValue.append(String.valueOf(voPrefix) + "<em>" + vo + "</em>");
            ++i;
        }
        values.put("infra", infrastructure);
        values.put("vos", voValue.toString());
        values.put("status", ((ApplicationState)this.context().lifecycle().state()).toString());
        values.put("smartgears-version", ProviderFactory.provider().smartgearsConfiguration().version());
        return values;
    }

    public static String interpolate(String text, Map<String, String> replacements) {
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, "");
            buffer.append(replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

