/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.lifecycle.container;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.smartgears.lifecycle.State;

public enum ContainerState implements State<ContainerState>
{
    notAuthorized("pending"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(active, failed);
        }

        @Override
        public String remoteForm() {
            return "started";
        }
    }
    ,
    started("start"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(active, failed);
        }

        @Override
        public String remoteForm() {
            return "started";
        }
    }
    ,
    partActive("part_activation"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(active, stopped, down);
        }

        @Override
        public String remoteForm() {
            return "ready";
        }
    }
    ,
    active("activation"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(partActive, stopped, down);
        }

        @Override
        public String remoteForm() {
            return "certified";
        }
    }
    ,
    stopped("stop"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(partActive, active);
        }

        @Override
        public String remoteForm() {
            return "down";
        }
    }
    ,
    down("shutdown"){

        @Override
        public List<ContainerState> next() {
            return Arrays.asList(partActive, active);
        }

        @Override
        public String remoteForm() {
            return "down";
        }
    }
    ,
    failed("failure"){

        @Override
        public List<ContainerState> next() {
            return Collections.emptyList();
        }

        @Override
        public String remoteForm() {
            return "failed";
        }
    };

    private final String event;

    private ContainerState(String event) {
        this.event = event;
    }

    @Override
    public String event() {
        return this.event;
    }

    /* synthetic */ ContainerState(String string, int n, String string2, ContainerState containerState) {
        this(string2);
    }
}

