/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.persistence.DefaultPersistence;
import org.gcube.smartgears.persistence.Persistence;

@XmlRootElement(name="application")
public class DefaultApplicationConfiguration
implements ApplicationConfiguration {
    @XmlAttribute
    private Mode mode = Mode.online;
    @XmlAttribute(name="isSecure")
    private boolean secure = false;
    @XmlAttribute(name="context")
    String context;
    @XmlElement(name="name", required=true)
    @NotNull
    String name;
    @XmlElement(name="group", required=true)
    @NotNull
    String group;
    @XmlElement(name="version", required=true)
    @NotNull
    String version;
    @XmlTransient
    Set<String> tokens = new HashSet<String>();
    @XmlElement(name="description")
    String description = "";
    @XmlElement(name="exclude")
    Set<String> excludes = new LinkedHashSet<String>();
    @XmlElementRef(type=DefaultPersistence.class)
    @NotNull
    @IsValid
    private Persistence persistenceManager;

    @Override
    public Set<String> excludes() {
        return this.excludes;
    }

    @Override
    public Mode mode() {
        return this.mode;
    }

    @Override
    public boolean secure() {
        return this.secure;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String context() {
        return this.context;
    }

    @Override
    public ApplicationConfiguration context(String context) {
        this.context = context;
        return this;
    }

    @Override
    public ApplicationConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String serviceClass() {
        return this.group;
    }

    @Override
    public ApplicationConfiguration serviceClass(String group) {
        this.group = group;
        return this;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public ApplicationConfiguration version(String version) {
        this.version = version;
        return this;
    }

    @Override
    public Set<String> startTokens() {
        return this.tokens;
    }

    @Override
    public ApplicationConfiguration startTokens(Set<String> tokens) {
        this.tokens.addAll(tokens);
        return this;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ApplicationConfiguration description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Persistence persistence() {
        return this.persistenceManager;
    }

    @Override
    public ApplicationConfiguration persistence(Persistence manager) {
        this.persistenceManager = manager;
        return this;
    }

    @Override
    public ApplicationConfiguration secure(boolean value) {
        this.secure = value;
        return this;
    }

    @Override
    public ApplicationConfiguration mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + msgs);
        }
    }

    @Override
    public void merge(ApplicationConfiguration config) {
        this.mode(config.mode());
        if (config.persistence() != null) {
            this.persistence(config.persistence());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.persistenceManager == null ? 0 : this.persistenceManager.hashCode());
        result = 31 * result + (this.tokens == null ? 0 : this.tokens.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultApplicationConfiguration other = (DefaultApplicationConfiguration)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.persistenceManager == null ? other.persistenceManager != null : !this.persistenceManager.equals(other.persistenceManager)) {
            return false;
        }
        if (this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return this.secure == other.secure;
    }
}

