package org.gcube.smartgears.handlers.application.request;

import static org.gcube.smartgears.Constants.*;
import static org.gcube.smartgears.handlers.application.request.RequestError.*;

import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.Constants;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name = Constants.request_validation)
public class RequestValidator extends RequestHandler {

	private static Logger log = LoggerFactory.getLogger(RequestValidator.class);

	private ApplicationContext context;

	@Override
	public void handleRequest(RequestEvent call) {

		context = call.context();
		
		validateAgainstLifecycle(call);

		validateScope(call);
		
	}

	private void validateAgainstLifecycle(RequestEvent call) {
		
		switch(context.lifecycle().state()) {
		
			case stopped :
				application_unavailable_error.fire(); break;
				
			case failed: 
				application_failed_error.fire(); break;
				
			default: 
				//nothing to do, but avoids warnings
		}
		
		
	}
	
	private void validateScope(RequestEvent call) {
		
		String scope = call.request().getHeader(scope_header);
				
		if (scope == null) {
			log.info("rejecting unscoped call to {}",context.name());
			invalid_request_error.fire("call is unscoped"); 
		}
		
		if (!context.profile(GCoreEndpoint.class).scopes().contains(scope)) {
			log.info("rejecting call to {} in invalid scope {}",context.name(),scope);
			invalid_request_error.fire(context.name()+" cannot be called in scope "+scope);
		}
		
		log.info("received call to {} in scope {}",call.uri(),scope);
		
		ScopeProvider.instance.set(scope);
		
	}

	
	@Override
	public String toString() {
		return request_validation;
	}
}
