/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletRegistration;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.lifecycle.application.ApplicationState;

public class ProfileBuilder {
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");
    private ApplicationContext context;

    public ProfileBuilder(ApplicationContext context) {
        this.context = context;
    }

    public void fill(GCoreEndpoint endpoint) {
        ApplicationConfiguration configuration = this.context.configuration();
        ContainerConfiguration container = this.context.container().configuration();
        endpoint.profile().description(configuration.description()).serviceName(configuration.name()).serviceClass(configuration.serviceClass()).version(configuration.version()).serviceId(configuration.name() + configuration.serviceClass() + configuration.version()).ghnId(this.context.container().profile(HostingNode.class).id());
        endpoint.profile().newDeploymentData().activationTime(Calendar.getInstance()).status(((ApplicationState)this.context.lifecycle().state()).remoteForm());
        endpoint.profile().endpoints().clear();
        String baseAddress = "http://" + container.hostname() + ":" + container.port() + this.context.application().getContextPath();
        for (ServletRegistration servlet : this.context.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().add()).nameAndAddress(this.context.configuration().entryFor(servlet.getName()), URI.create(address));
            }
        }
    }
}

