package org.gcube.smartgears.configuration.application;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.gcube.smartgears.configuration.application.DefaultApplicationConfiguration.MapElement;
import org.gcube.smartgears.configuration.application.DefaultApplicationConfiguration.ServletConfiguration;



@XmlRootElement(name = "servlets")
public class EntryNamesMapAdapter extends XmlAdapter<MapElement, Map<String, ServletConfiguration>> {

	    @Override
	    public MapElement marshal(Map<String, ServletConfiguration> v) throws Exception {

	        if (v == null || v.isEmpty()) {return null;}

	        MapElement map = new MapElement();

	        for (String key : v.keySet()) {
	            map.addEntry(key, v.get(key));
	        }

	        return map;
	    }

	    @Override
	    public Map<String, ServletConfiguration> unmarshal(MapElement v) throws Exception {
	        if (v == null) {return null;}

	        Map<String, ServletConfiguration> map = new HashMap<String, ServletConfiguration>(v.entries.size());

	        for(ServletConfiguration entry: v.entries) {
	            map.put(entry.name, new ServletConfiguration(entry.name, entry.entryPointName));
	        }

	        return map;
	    }
   
	
	    
}

