/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.container.Site;
import org.gcube.smartgears.persistence.DefaultPersistence;
import org.gcube.smartgears.persistence.Persistence;
import org.gcube.smartgears.utils.Utils;

@XmlRootElement(name="container")
public class ContainerConfiguration {
    @XmlAttribute
    private Mode mode = Mode.online;
    @XmlElement
    @NotNull
    String hostname;
    @XmlElement
    @NotNull
    Integer port;
    @XmlElement
    @NotNull
    String infrastructure;
    @XmlElement
    @NotNull
    @IsValid
    Site site;
    @XmlElement(name="vo")
    List<String> vos = new ArrayList<String>();
    @XmlElement(name="property")
    @IsValid
    List<Property> properties = new ArrayList<Property>();
    @XmlElement(name="publication-frequency")
    long publicationFrequency = 60L;
    @XmlElementRef(type=DefaultPersistence.class)
    @IsValid
    private Persistence persistenceManager;

    public Mode mode() {
        return this.mode;
    }

    public ContainerConfiguration mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Site site() {
        return this.site;
    }

    public ContainerConfiguration site(Site site) {
        this.site = site;
        return this;
    }

    public String infrastructure() {
        return this.infrastructure;
    }

    public ContainerConfiguration infrastructure(String infrastructure) {
        this.infrastructure = infrastructure;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ContainerConfiguration hostname(String name) {
        this.hostname = name;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ContainerConfiguration port(int port) {
        this.port = port;
        return this;
    }

    public List<String> startVOs() {
        return this.vos;
    }

    public ContainerConfiguration startVOs(String ... vos) {
        Utils.notNull("start VOs", vos);
        if (vos != null && vos.length > 0) {
            this.vos = Arrays.asList(vos);
        }
        return this;
    }

    public List<String> startScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("/" + this.infrastructure());
        for (String vo : this.startVOs()) {
            scopes.add("/" + this.infrastructure() + "/" + vo);
        }
        return scopes;
    }

    public Persistence persistence() {
        return this.persistenceManager;
    }

    public ContainerConfiguration persistence(Persistence manager) {
        this.persistenceManager = manager;
        return this;
    }

    public Map<String, String> properties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Property prop : this.properties) {
            map.put(prop.name, prop.value);
        }
        return map;
    }

    public ContainerConfiguration property(String name, String value) {
        this.properties.add(new Property(name, value));
        return this;
    }

    public long publicationFrequency() {
        return this.publicationFrequency;
    }

    public ContainerConfiguration publicationFrequency(long frequency) {
        this.publicationFrequency = frequency;
        return this;
    }

    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + msgs);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.infrastructure == null ? 0 : this.infrastructure.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.persistenceManager == null ? 0 : this.persistenceManager.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.publicationFrequency ^ this.publicationFrequency >>> 32);
        result = 31 * result + (this.site == null ? 0 : this.site.hashCode());
        result = 31 * result + (this.vos == null ? 0 : this.vos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerConfiguration other = (ContainerConfiguration)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.infrastructure == null ? other.infrastructure != null : !this.infrastructure.equals(other.infrastructure)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.persistenceManager == null ? other.persistenceManager != null : !this.persistenceManager.equals(other.persistenceManager)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.publicationFrequency != other.publicationFrequency) {
            return false;
        }
        if (this.site == null ? other.site != null : !this.site.equals(other.site)) {
            return false;
        }
        return !(this.vos == null ? other.vos != null : !this.vos.equals(other.vos));
    }

    static class Property {
        @XmlAttribute
        @NotNull
        String name;
        @XmlAttribute
        @NotNull
        String value;

        Property() {
        }

        Property(String key, String value) {
            this.name = key;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

