package org.gcube.smartgears.utils;

import static org.gcube.smartgears.Constants.*;
import static org.gcube.smartgears.handlers.application.request.RequestError.*;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.smartgears.Constants;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.handlers.application.request.RequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Library-wide utils.
 * 
 * @author Fabio Simeoni
 *
 */
public class Utils {

	private static final Logger log = LoggerFactory.getLogger(Utils.class);

	public static boolean isResource(ServletContext application) {
		return application.getResourceAsStream(Constants.configuration_file_path) != null;
	}

	public static RuntimeException unchecked(Throwable t) {

		return (t instanceof RuntimeException) ? RuntimeException.class.cast(t) : new RuntimeException(t.getMessage(),
				t);

	}
	
	public static String smartgearsVersion() {
		return "1.0.0"; //@TODO
	}
	
	public static void rethrowUnchecked(Throwable t) throws RuntimeException {

		throw unchecked(t);

	}
	
	public static void closeSafely(Closeable c) {
		
		if (c != null) {
			try {
				
				if (c instanceof Flushable)
					Flushable.class.cast(c).flush();
					
				c.close();
				
			} catch (IOException e) {
				log.error("could not close {} due to error {}: msg{}",c,e.getClass().getSimpleName(),e.getMessage());
			}

		}
	}

	public static void valid(String name, Object[] o) throws IllegalArgumentException {
		notNull(name, o);

	}

	public static void notNull(Object[] o) throws IllegalArgumentException {
		notNull("argument", o);
	}

	public static void notNull(String name, Object o) throws IllegalArgumentException {
		if (o == null)
			throw new IllegalArgumentException(name + " is null");
	}

	public static void notEmpty(String name, String o) throws IllegalArgumentException {
		notNull(name,o);
		if (o.isEmpty())
			throw new IllegalArgumentException(name + " is empty");
	}

	public static void notEmpty(String name, Object[] o) throws IllegalArgumentException {
		notNull(name,o);
		if (o.length == 0)
			throw new IllegalArgumentException(name + " is empty");
	}
	
	public static void notEmpty(String name, Collection<?> o) throws IllegalArgumentException {
		notNull(name,o);
		if (o.isEmpty())
			throw new IllegalArgumentException(name + " is empty");
	}

	public static void valid(String name, String o) throws IllegalArgumentException {
		notNull(name, o);
		notEmpty(name, o);
	}
	
	
	public static String home() {
		
		String home = System.getenv(ghn_home_env);

		if (home == null)
			home = System.getProperty(ghn_home_property);

		return home;

	}
	
	public static void handleError(HttpServletRequest request, HttpServletResponse response,Throwable t) throws IOException {
		
		RequestError error = t instanceof RequestException?
							 RequestException.class.cast(t).error():
							 application_error;
				
		if (error == application_error) {
			response.getWriter().write("Error ("+error.code()+") : "+t.getMessage()+"\nStacktrace:\n");
			t.printStackTrace(response.getWriter());
			response.setStatus(error.code());

		}
		else
			response.sendError(error.code(),t.getMessage());
		

	}
	

}
