/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.utils.sweeper;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweeper {
    String ghn_state_path = "";
    Logger logger = LoggerFactory.getLogger(Sweeper.class);

    public Sweeper() throws Exception {
        String ghn_path = System.getenv("GHN_HOME");
        if (ghn_path == null) {
            this.logger.error("GHN_HOME not defined");
            throw new Exception("GHN_HOME not defined");
        }
        this.ghn_state_path = ghn_path + File.separator + "state";
    }

    public void forceDeleteHostingNode() {
        List tokens;
        String id;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.ghn_state_path + File.separator + "ghn.xml"));){
            id = (String)ois.readObject();
            tokens = (List)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("error loading persisted state");
        }
        RegistryPublisher rp = RegistryPublisherFactory.create();
        System.out.println(" id to remove is " + id);
        try {
            DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
            XQuery query = ICFactory.queryFor(HostingNode.class);
            query.addCondition("$resource/ID/text() = '" + id + "'");
            for (String token : tokens) {
                AuthorizationEntry entry = Constants.authorizationService().get(token);
                SecurityTokenProvider.instance.set(token);
                ScopeProvider.instance.set(entry.getContext());
                System.out.println("trying to remove resource in scope " + entry.getContext());
                List nodes = client.submit((Query)query);
                System.out.println(" node is empty? " + nodes.isEmpty());
                if (nodes.isEmpty()) continue;
                rp.remove((Resource)nodes.get(0));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error removing hosting node resource", e);
        }
    }
}

