/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.application.manager.AppManagerObserver;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ContextListener
implements ServletContextListener {
    private static Logger log = LoggerFactory.getLogger(ContextListener.class);
    AppManagerObserver observer;

    public void contextInitialized(ServletContextEvent sce) {
        ApplicationContext context = (ApplicationContext)sce.getServletContext().getAttribute("gcube-application-context");
        if (context == null) {
            String msg = sce.getServletContext().getContextPath() + " is a gCube-aware application but is not managed as a gCube resource: missing or invalid context attribute gcube-application-context";
            throw new RuntimeException(msg);
        }
        log.info("configuring context provider for {}", (Object)context.name());
        ContextProvider.set(context);
        this.retrieveAndRegisterManagers(context);
    }

    private void retrieveAndRegisterManagers(ApplicationContext context) {
        Set annotatedManaged;
        ApplicationManagerProvider.init(context);
        try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(ManagedBy.class.getName());
            annotatedManaged = classInfos.stream().map(ClassInfo::loadClass).collect(Collectors.toSet());
        }
        log.debug("annotated managed are {} for {}", (Object)annotatedManaged.size(), (Object)context.name());
        HashSet<Class<? extends ApplicationManager>> managers = new HashSet<Class<? extends ApplicationManager>>();
        for (Class initializer : annotatedManaged) {
            ManagedBy manageBy = initializer.getAnnotation(ManagedBy.class);
            log.info("ApplicationManager added {} to {} @ {}", new Object[]{manageBy.value().getSimpleName(), initializer.getSimpleName(), context.name()});
            managers.add(manageBy.value());
        }
        if (managers.size() > 0) {
            this.observer = ApplicationManagerProvider.instance.getObserver();
            this.observer.setAuthorizationProvider(context.container().authorizationProvider());
            this.observer.setApplicationManagerClasses(managers);
            this.observer.register();
            context.events().subscribe((Object)this.observer);
        } else {
            log.info("no application managers found for {}", (Object)context.name());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.observer != null) {
            ApplicationContext context = (ApplicationContext)sce.getServletContext().getAttribute("gcube-application-context");
            context.events().unsubscribe((Object)this.observer);
            this.observer.onStop(context);
        }
    }
}

