/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.application.manager.AppManagerObserver;
import org.gcube.smartgears.application.manager.OfflineProvider;
import org.gcube.smartgears.application.manager.OnlineProvider;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationManagerProvider {
    private static Logger logger = LoggerFactory.getLogger(ApplicationManagerProvider.class);
    private Map<String, Class<?>> proxyClassMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> classProxyObjetMap = Collections.synchronizedMap(new HashMap());
    protected static ApplicationManagerProvider instance;
    private static boolean initialized;

    protected static synchronized void init(ApplicationContext appcontext) {
        if (!initialized) {
            instance = appcontext.container().configuration().mode() == Mode.offline ? new OfflineProvider() : new OnlineProvider();
            initialized = true;
        }
    }

    public static synchronized ApplicationManager get(Class<? extends ApplicationManager> applicationManagerClass) {
        if (!initialized) {
            throw new RuntimeException("ApplicationManagerProvider not yet initialized");
        }
        logger.debug("retrieveing application manager of {} ", (Object)applicationManagerClass.getCanonicalName());
        Object obj = instance.getApplicationManagerObject(applicationManagerClass);
        return applicationManagerClass.cast(obj);
    }

    private Object getApplicationManagerObject(Class<? extends ApplicationManager> applicationManagerClass) {
        Object obj;
        try {
            Class<?> _class = this.getProxyClass(applicationManagerClass);
            if (this.classProxyObjetMap.containsKey(_class.getCanonicalName())) {
                Object obj2 = this.classProxyObjetMap.get(_class.getCanonicalName());
                logger.trace("getting object {} from cache ", (Object)_class.getCanonicalName());
                return obj2;
            }
            obj = _class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.classProxyObjetMap.put(_class.getCanonicalName(), obj);
            logger.debug("proxy created for {} ", (Object)applicationManagerClass.getCanonicalName());
        }
        catch (Exception e) {
            throw new RuntimeException("error creating proxy ", e);
        }
        ((ProxyObject)obj).setHandler(this.getMethodHandler(applicationManagerClass));
        return obj;
    }

    protected synchronized ApplicationManager get() {
        Class<? extends ApplicationManager> applicationManagerClass = this.retrieveManagerClass();
        return ApplicationManagerProvider.get(applicationManagerClass);
    }

    private Class<?> getProxyClass(Class<? extends ApplicationManager> applicationManagerClass) {
        if (this.proxyClassMap.containsKey(applicationManagerClass.getCanonicalName())) {
            logger.debug("getting proxy class {} for appManager from cache ", (Object)applicationManagerClass.getCanonicalName());
            return this.proxyClassMap.get(applicationManagerClass.getCanonicalName());
        }
        logger.debug("creating new proxy class for appManager " + applicationManagerClass.getCanonicalName());
        ProxyFactory proxyfactory = new ProxyFactory();
        proxyfactory.setSuperclass(applicationManagerClass);
        Class proxyClass = proxyfactory.createClass();
        this.proxyClassMap.put(applicationManagerClass.getCanonicalName(), proxyClass);
        return proxyClass;
    }

    protected Class<? extends ApplicationManager> retrieveManagerClass() {
        ManagedBy annotation;
        String classname = Thread.currentThread().getStackTrace()[3].getClassName();
        logger.trace("managed servlet caller is {}", (Object)classname);
        try {
            annotation = Class.forName(classname).getAnnotation(ManagedBy.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("error initializing ApplicationManager", e);
        }
        if (annotation == null) {
            logger.error(" {} is not managed by an ApplicationManager", (Object)classname);
            throw new RuntimeException(classname + " is not managed by an ApplicationManager");
        }
        return annotation.value();
    }

    protected abstract Future<ApplicationManager> retrieveFuture(Class<? extends ApplicationManager> var1);

    protected abstract MethodHandler getMethodHandler(Class<? extends ApplicationManager> var1);

    protected abstract AppManagerObserver getObserver();

    static {
        initialized = false;
    }
}

