/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.application.manager;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.application.manager.AppManagerObserver;
import org.gcube.smartgears.application.manager.OfflineProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.security.AuthorizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineObserver
implements AppManagerObserver {
    private static Logger log = LoggerFactory.getLogger(OfflineObserver.class);
    private static ExecutorService service = Executors.newCachedThreadPool();
    private Set<Class<? extends ApplicationManager>> managerClasses;
    private OfflineProvider provider;

    public OfflineObserver(OfflineProvider provider) {
        this.provider = provider;
    }

    @Override
    public void register() {
        this.onRegistration(null);
    }

    @Override
    @Observes(value={"token-registered"}, kind=Observes.Kind.safe)
    public synchronized void onRegistration(String parameter) {
        log.info("offline registration");
        for (Class<? extends ApplicationManager> appManager : this.managerClasses) {
            Future<ApplicationManager> appManagerFuture = service.submit(new OfflineInitAppManager(appManager));
            this.provider.getAppmanagerMap().put(appManager.getCanonicalName(), appManagerFuture);
        }
    }

    @Override
    @Observes(value={"token-removed"}, kind=Observes.Kind.critical)
    public synchronized void onRemove(String securityToken) {
    }

    @Override
    public synchronized void onStop(ApplicationContext appContext) {
        this.provider.getAppmanagerMap().values().forEach(v -> {
            try {
                ((ApplicationManager)v.get()).onShutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("error shutting down appmanager ");
            }
        });
        this.unregister();
    }

    @Override
    public void unregister() {
        service.shutdownNow();
    }

    @Override
    public void setApplicationManagerClasses(Set<Class<? extends ApplicationManager>> managerClasses) {
        this.managerClasses = managerClasses;
    }

    @Override
    public void setAuthorizationProvider(AuthorizationProvider authProvider) {
    }

    public class OfflineShutDownAppManager
    implements Runnable {
        private Future<ApplicationManager> appManager;

        public OfflineShutDownAppManager(Future<ApplicationManager> appManager) {
            this.appManager = appManager;
        }

        @Override
        public void run() {
            try {
                log.info("calling on ShutDown of {} ", (Object)this.appManager.getClass().getCanonicalName());
                this.appManager.get().onShutdown();
            }
            catch (Exception e) {
                log.warn("error on onShutdown of {} ", (Object)this.appManager.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    public class OfflineInitAppManager
    implements Callable<ApplicationManager> {
        private Class<? extends ApplicationManager> managerClass;

        public OfflineInitAppManager(Class<? extends ApplicationManager> managerClass) {
            this.managerClass = managerClass;
        }

        @Override
        public ApplicationManager call() throws Exception {
            ApplicationManager manager = this.managerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                log.info("calling on onInit of {}", (Object)manager.getClass().getCanonicalName());
                manager.onInit();
            }
            catch (Exception e) {
                log.warn("error on onInit of {}", (Object)manager.getClass().getCanonicalName(), (Object)e);
            }
            return manager;
        }
    }
}

