/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.application.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gcube.common.events.Observes;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ManagerPair;
import org.gcube.smartgears.application.manager.AppManagerObserver;
import org.gcube.smartgears.application.manager.OnlineProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.security.AuthorizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineObserver
implements AppManagerObserver {
    private static Logger log = LoggerFactory.getLogger(OnlineObserver.class);
    private static ExecutorService service = Executors.newCachedThreadPool();
    private Map<String, List<ManagerPair>> instanciatedManagerPerScope = new HashMap<String, List<ManagerPair>>();
    private OnlineProvider provider;
    private AuthorizationProvider authProvider;
    private Set<Class<? extends ApplicationManager>> managersClasses;

    public OnlineObserver(OnlineProvider provider) {
        this.provider = provider;
    }

    @Override
    public void register() {
        for (String context : this.authProvider.getContexts()) {
            this.onRegistration(context);
        }
    }

    @Override
    @Observes(value={"token-registered"}, kind=Observes.Kind.safe)
    public synchronized void onRegistration(String context) {
        log.info("registration called in context {}", (Object)context);
        ArrayList<ManagerPair> futureList = new ArrayList<ManagerPair>();
        try {
            Secret secret = this.authProvider.getSecretForContext(context);
            for (Class<? extends ApplicationManager> appManager : this.managersClasses) {
                Future<ApplicationManager> appManagerFuture = service.submit(new InitAppManager(secret, appManager));
                log.info("intializing app using manager {} in context {}", (Object)appManager.getClass().getCanonicalName(), (Object)context);
                futureList.add(new ManagerPair(appManager, appManagerFuture));
                if (this.provider.getAppmanagerMap().containsKey(appManager.getCanonicalName())) {
                    this.provider.getAppmanagerMap().get(appManager.getCanonicalName()).put(context, appManagerFuture);
                    continue;
                }
                HashMap<String, Future<ApplicationManager>> tokenFutureMap = new HashMap<String, Future<ApplicationManager>>();
                tokenFutureMap.put(context, appManagerFuture);
                this.provider.getAppmanagerMap().put(appManager.getCanonicalName(), tokenFutureMap);
            }
            if (!futureList.isEmpty()) {
                this.instanciatedManagerPerScope.put(context, futureList);
            }
        }
        catch (Exception e1) {
            log.error("something failed getting authorization", (Throwable)e1);
            throw new RuntimeException("something failed getting authorization", e1);
        }
    }

    @Override
    @Observes(value={"token-removed"}, kind=Observes.Kind.critical)
    public synchronized void onRemove(String context) {
        try {
            Secret secret = this.authProvider.getSecretForContext(context);
            if (this.instanciatedManagerPerScope.get(context) != null) {
                for (ManagerPair manager : this.instanciatedManagerPerScope.get(context)) {
                    service.execute(new ShutDownAppManager(secret, manager.getFuture()));
                    this.provider.getAppmanagerMap().get(manager.getImplementationClass().getCanonicalName()).remove(context);
                }
                this.instanciatedManagerPerScope.remove(context);
            }
            this.instanciatedManagerPerScope.remove(context);
        }
        catch (Exception e1) {
            log.error("something failed getting token", (Throwable)e1);
            throw new RuntimeException("something failed getting token", e1);
        }
    }

    @Override
    public synchronized void onStop(ApplicationContext appContext) {
        for (String context : appContext.authorizationProvider().getContexts()) {
            this.onRemove(context);
        }
        this.unregister();
    }

    @Override
    public void unregister() {
        service.shutdownNow();
    }

    @Override
    public void setAuthorizationProvider(AuthorizationProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public void setApplicationManagerClasses(Set<Class<? extends ApplicationManager>> managersClasses) {
        this.managersClasses = managersClasses;
    }

    public class ShutDownAppManager
    implements Runnable {
        private Future<ApplicationManager> appManager;
        private Secret secret;

        public ShutDownAppManager(Secret secret, Future<ApplicationManager> appManager) {
            this.appManager = appManager;
        }

        @Override
        public void run() {
            SecretManagerProvider.instance.set(this.secret);
            try {
                log.info("calling on ShutDown of {} on context {}", (Object)this.appManager.getClass().getCanonicalName(), (Object)this.secret.getContext());
                this.appManager.get().onShutdown();
            }
            catch (Exception e) {
                log.warn("error on onShutdown of {} on context {}", new Object[]{this.appManager.getClass().getCanonicalName(), this.secret.getContext(), e});
            }
            finally {
                SecretManagerProvider.instance.reset();
            }
        }
    }

    public class InitAppManager
    implements Callable<ApplicationManager> {
        private Class<? extends ApplicationManager> managerClass;
        private Secret secret;

        public InitAppManager(Secret secret, Class<? extends ApplicationManager> managerClass) {
            this.managerClass = managerClass;
            this.secret = secret;
        }

        @Override
        public ApplicationManager call() throws Exception {
            log.info("on init called");
            SecretManagerProvider.instance.set(this.secret);
            ApplicationManager manager = null;
            try {
                manager = this.managerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("calling on onInit on manager {} with secret {}", (Object)manager.getClass().getCanonicalName(), (Object)this.secret);
                manager.onInit();
            }
            catch (Exception e) {
                log.warn("error on onInit of {} on context {}", new Object[]{manager.getClass().getCanonicalName(), this.secret.getContext(), e});
            }
            finally {
                SecretManagerProvider.instance.reset();
            }
            return manager;
        }
    }
}

