/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.application.manager;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javassist.util.proxy.MethodHandler;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.application.manager.AppManagerObserver;
import org.gcube.smartgears.application.manager.OnlineObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineProvider
extends ApplicationManagerProvider {
    private static Logger logger = LoggerFactory.getLogger(OnlineProvider.class);
    private Map<String, Map<String, Future<ApplicationManager>>> appManagerMap = new HashMap<String, Map<String, Future<ApplicationManager>>>();
    private OnlineObserver observer = new OnlineObserver(this);

    @Override
    protected Future<ApplicationManager> retrieveFuture(Class<? extends ApplicationManager> applicationManagerClass) {
        return this.appManagerMap.get(applicationManagerClass.getCanonicalName()).get(ScopeProvider.instance.get());
    }

    @Override
    protected MethodHandler getMethdoHandler(final Class<? extends ApplicationManager> applicationManagerClass) {
        MethodHandler handler = new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                if (ScopeProvider.instance.get() == null) {
                    throw new RuntimeException("error invoking application manager method, scope is not set in this thread");
                }
                logger.debug("applicationManagerClass is {}", (Object)applicationManagerClass.getCanonicalName());
                Future<ApplicationManager> appManagerFuture = OnlineProvider.this.retrieveFuture(applicationManagerClass);
                logger.debug("appmanager future is null? {}", (Object)(appManagerFuture == null ? 1 : 0));
                logger.debug("thisMethod is null? {}", (Object)(thisMethod == null ? 1 : 0));
                return thisMethod.invoke((Object)appManagerFuture.get(), args);
            }
        };
        return handler;
    }

    public Map<String, Map<String, Future<ApplicationManager>>> getAppmanagerMap() {
        return this.appManagerMap;
    }

    @Override
    protected AppManagerObserver getObserver() {
        return this.observer;
    }
}

