/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterApplicationManagerObserver {
    private static Logger log = LoggerFactory.getLogger(RegisterApplicationManagerObserver.class);
    private static ExecutorService service = Executors.newCachedThreadPool();
    private Set<Class<? extends ApplicationManager>> managersClass;
    private Map<String, List<Future<ApplicationManager>>> instanciatedManagerPerScope = new HashMap<String, List<Future<ApplicationManager>>>();

    public RegisterApplicationManagerObserver(Set<Class<? extends ApplicationManager>> managersClass, Collection<String> startingTokens) {
        this.managersClass = managersClass;
        for (String startingToken : startingTokens) {
            this.onRegistation(startingToken);
        }
    }

    @Observes(value={"token-registered"}, kind=Observes.Kind.safe)
    public synchronized void onRegistation(String securityToken) {
        log.info("token registered called with token {}", (Object)securityToken);
        ArrayList<Future<ApplicationManager>> futureList = new ArrayList<Future<ApplicationManager>>();
        try {
            String context = Constants.authorizationService().get(securityToken).getContext();
            for (Class<? extends ApplicationManager> appManager : this.managersClass) {
                Future<ApplicationManager> appManagerFuture = service.submit(new InitAppManager(securityToken, context, appManager));
                log.info("intializing app in context {} with token {} ", (Object)context, (Object)securityToken);
                futureList.add(appManagerFuture);
                if (ApplicationManagerProvider.appManagerMap.containsKey(appManager.getCanonicalName())) {
                    ApplicationManagerProvider.appManagerMap.get(appManager.getCanonicalName()).put(context, appManagerFuture);
                    continue;
                }
                HashMap<String, Future<ApplicationManager>> tokenFutureMap = new HashMap<String, Future<ApplicationManager>>();
                tokenFutureMap.put(context, appManagerFuture);
                ApplicationManagerProvider.appManagerMap.put(appManager.getCanonicalName(), tokenFutureMap);
            }
            if (!futureList.isEmpty()) {
                this.instanciatedManagerPerScope.put(context, futureList);
            }
        }
        catch (ObjectNotFound e1) {
            log.error("it should never happen (token has just been created)", (Throwable)e1);
            throw new RuntimeException("it should never happen (token has just been created", e1);
        }
        catch (Exception e1) {
            log.error("something failed getting token", (Throwable)e1);
            throw new RuntimeException("something failed getting token", e1);
        }
    }

    @Observes(value={"token-removed"}, kind=Observes.Kind.critical)
    public synchronized void onRemove(String securityToken) {
        try {
            String context = Constants.authorizationService().get(securityToken).getContext();
            for (Future<ApplicationManager> appManager : this.instanciatedManagerPerScope.get(context)) {
                service.execute(new ShutDownAppManager(securityToken, context, appManager));
                ApplicationManagerProvider.appManagerMap.get(appManager).remove(context);
            }
            this.instanciatedManagerPerScope.remove(context);
            SecurityTokenProvider.instance.reset();
        }
        catch (ObjectNotFound e1) {
            log.error("it should never happen (token has just been created)", (Throwable)e1);
            throw new RuntimeException("it should never happen (token has just been created", e1);
        }
        catch (Exception e1) {
            log.error("something failed getting token", (Throwable)e1);
            throw new RuntimeException("something failed getting token", e1);
        }
    }

    public synchronized void onStop(ApplicationContext appContext) {
        for (String token : appContext.configuration().startTokens()) {
            try {
                String context = Constants.authorizationService().get(token).getContext();
                for (Future<ApplicationManager> appManagerEntry : this.instanciatedManagerPerScope.get(context)) {
                    try {
                        log.info("stoppping {} in context {} ", (Object)appContext.name(), (Object)context);
                        SecurityTokenProvider.instance.set(token);
                        ScopeProvider.instance.set(context);
                        try {
                            appManagerEntry.get().onShutdown();
                            log.info("manager {} correctly suhtdown on context {}", (Object)appContext.name(), (Object)context);
                        }
                        catch (Exception e) {
                            log.warn("problem calling onShutdown for context {}", (Object)context, (Object)e);
                        }
                    }
                    catch (Exception e) {
                        log.error("error retrieving token on shutdown on context {}", (Object)context, (Object)e);
                        throw new RuntimeException("error retrieving token on shutdown", e);
                    }
                    finally {
                        ScopeProvider.instance.reset();
                        SecurityTokenProvider.instance.reset();
                    }
                }
            }
            catch (ObjectNotFound e1) {
                log.error("token not found : {}", (Object)token, (Object)e1);
            }
            catch (Exception e1) {
                log.error("something failed getting token {}", (Object)token, (Object)e1);
            }
        }
        this.unregister();
    }

    public void unregister() {
        service.shutdownNow();
    }

    public class ShutDownAppManager
    implements Runnable {
        private Future<ApplicationManager> appManager;
        private String securityToken;
        private String context;

        public ShutDownAppManager(String securityToken, String context, Future<ApplicationManager> appManager) {
            this.appManager = appManager;
            this.securityToken = securityToken;
            this.context = context;
        }

        @Override
        public void run() {
            SecurityTokenProvider.instance.set(this.securityToken);
            ScopeProvider.instance.set(this.context);
            try {
                log.info("calling on ShutDown of {} on token {}", (Object)this.appManager.getClass().getCanonicalName(), (Object)this.securityToken);
                this.appManager.get().onShutdown();
            }
            catch (Exception e) {
                log.warn("error on onShutdown of {} on token {}", new Object[]{this.appManager.getClass().getCanonicalName(), this.securityToken, e});
            }
            finally {
                ScopeProvider.instance.reset();
                SecurityTokenProvider.instance.reset();
            }
        }
    }

    public class InitAppManager
    implements Callable<ApplicationManager> {
        private Class<? extends ApplicationManager> managerClass;
        private String securityToken;
        private String context;

        public InitAppManager(String securityToken, String context, Class<? extends ApplicationManager> managerClass) {
            this.managerClass = managerClass;
            this.securityToken = securityToken;
            this.context = context;
        }

        @Override
        public ApplicationManager call() throws Exception {
            SecurityTokenProvider.instance.set(this.securityToken);
            ScopeProvider.instance.set(this.context);
            ApplicationManager manager = this.managerClass.newInstance();
            try {
                log.info("calling on onInit of {} on token {}", (Object)manager.getClass().getCanonicalName(), (Object)this.securityToken);
                manager.onInit();
            }
            catch (Exception e) {
                log.warn("error on onInit of {} on token {}", new Object[]{manager.getClass().getCanonicalName(), this.securityToken, e});
            }
            finally {
                ScopeProvider.instance.reset();
                SecurityTokenProvider.instance.reset();
            }
            return manager;
        }
    }
}

