/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.RegisterApplicationManagerObserver;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ContextListener
implements ServletContextListener {
    private static Logger log = LoggerFactory.getLogger(ContextListener.class);
    RegisterApplicationManagerObserver observer;

    public void contextInitialized(ServletContextEvent sce) {
        ApplicationContext context = (ApplicationContext)sce.getServletContext().getAttribute("gcube-application-context");
        if (context == null) {
            String msg = sce.getServletContext().getContextPath() + " is a gCube-aware application but is not managed as a gCube resource: missing or invalid context attribute " + "gcube-application-context";
            throw new RuntimeException(msg);
        }
        log.info("configuring context provider for {}", (Object)context.name());
        ContextProvider.set(context);
        this.retrieveAndRegisterManagers(context);
    }

    private void retrieveAndRegisterManagers(ApplicationContext context) {
        ConfigurationBuilder reflectionConf = new ConfigurationBuilder().addUrls(ClasspathHelper.forClassLoader()).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflection = new Reflections((Configuration)reflectionConf);
        Set toInitialize = reflection.getTypesAnnotatedWith(ManagedBy.class);
        HashSet<Class<? extends ApplicationManager>> managers = new HashSet<Class<? extends ApplicationManager>>();
        for (Class initializer : toInitialize) {
            ManagedBy manageBy = initializer.getAnnotation(ManagedBy.class);
            log.info("ApplicationManager added {} @ {}", (Object)manageBy.value().getSimpleName(), (Object)context.name());
            managers.add(manageBy.value());
        }
        if (managers.size() > 0) {
            this.observer = new RegisterApplicationManagerObserver(managers, context.configuration().startTokens());
            context.events().subscribe((Object)this.observer);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.observer != null) {
            ApplicationContext context = (ApplicationContext)sce.getServletContext().getAttribute("gcube-application-context");
            context.events().unsubscribe((Object)this.observer);
            this.observer.onStop(context);
        }
    }
}

