/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationManagerProvider {
    private static Logger logger = LoggerFactory.getLogger(ApplicationManagerProvider.class);
    static Map<String, Map<String, Future<ApplicationManager>>> appManagerMap = new HashMap<String, Map<String, Future<ApplicationManager>>>();
    private static Map<String, Class<?>> proxyClassMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, Object> classProxyObjetMap = Collections.synchronizedMap(new HashMap());

    public static synchronized ApplicationManager get() {
        Class<? extends ApplicationManager> applicationManagerClass = ApplicationManagerProvider.retrieveManagerClass();
        return ApplicationManagerProvider.get(applicationManagerClass);
    }

    public static synchronized ApplicationManager get(final Class<? extends ApplicationManager> applicationManagerClass) {
        Object obj;
        try {
            Class<?> _class = ApplicationManagerProvider.getProxyClass(applicationManagerClass);
            if (classProxyObjetMap.containsKey(_class.getCanonicalName())) {
                Object obj2 = classProxyObjetMap.get(_class.getCanonicalName());
                logger.trace("getting object {} from cache ", (Object)_class.getCanonicalName());
                return applicationManagerClass.cast(obj2);
            }
            obj = _class.newInstance();
            classProxyObjetMap.put(_class.getCanonicalName(), obj);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating proxy ", e);
        }
        MethodHandler handler = new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                if (ScopeProvider.instance.get() == null) {
                    throw new RuntimeException("error invoking application manager method, scope is not set in this thread");
                }
                logger.debug("applicationManagerClass is {}", (Object)applicationManagerClass.getCanonicalName());
                Future<ApplicationManager> appManagerFuture = appManagerMap.get(applicationManagerClass.getCanonicalName()).get(ScopeProvider.instance.get());
                logger.debug("appmanager future is null? {}", (Object)(appManagerFuture == null ? 1 : 0));
                logger.debug("thisMethod is null? {}", (Object)(thisMethod == null ? 1 : 0));
                return thisMethod.invoke((Object)appManagerFuture.get(), args);
            }
        };
        ((ProxyObject)obj).setHandler(handler);
        return applicationManagerClass.cast(obj);
    }

    private static Class<?> getProxyClass(Class<? extends ApplicationManager> applicationManagerClass) {
        if (proxyClassMap.containsKey(applicationManagerClass.getCanonicalName())) {
            logger.debug("getting proxy class {} for appManager from cache ", (Object)applicationManagerClass.getCanonicalName());
            return proxyClassMap.get(applicationManagerClass.getCanonicalName());
        }
        logger.debug("creating new proxy class for appManager " + applicationManagerClass.getCanonicalName());
        ProxyFactory proxyfactory = new ProxyFactory();
        proxyfactory.setSuperclass(applicationManagerClass);
        Class proxyClass = proxyfactory.createClass();
        proxyClassMap.put(applicationManagerClass.getCanonicalName(), proxyClass);
        return proxyClass;
    }

    private static Class<? extends ApplicationManager> retrieveManagerClass() {
        ManagedBy annotation;
        String classname = Thread.currentThread().getStackTrace()[3].getClassName();
        logger.trace("managed servlet caller is {}", (Object)classname);
        try {
            annotation = Class.forName(classname).getAnnotation(ManagedBy.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("error initializing ApplicationManager", e);
        }
        if (annotation == null) {
            logger.error(" {} is not managed by an ApplicationManager", (Object)classname);
            throw new RuntimeException(classname + " is not managed by an ApplicationManager");
        }
        return annotation.value();
    }
}

