package org.gcube.common.scope.impl;

import java.util.List;
import java.util.Map;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.api.ServiceMap;

/**
 * A {@link ServiceMap} that forwards requests to {@link ServiceMap}s associated
 * with the scope of callers.
 * <p>
 * At construction time, it configures itself with all the service maps found
 * the classpath (excluding URLs available to primordial and extension
 * classloader). Recognises service maps as resources whose names match a
 * {@link ServiceMapScanner#mapConfigPattern}.
 * 
 * @author Fabio Simeoni
 * 
 */
public class ScopedServiceMap implements ServiceMap {

	private final Map<String, ServiceMap> maps;


	public ScopedServiceMap() {
		maps = ServiceMapScanner.maps();
	}

	@Override
	public String scope() {
		return ScopeProvider.instance.get();
	}

	@Override
	public List<String> endpoint(String service) {

		String currentScope = scope();

		ServiceMap map = maps.get(currentScope);

		return map == null ? null : map.endpoint(service);
	}

	
}
