package org.gcube.common.scope.api;

import java.util.List;

import org.gcube.common.scope.impl.ScopedServiceMap;

/**
 * Resolves service endpoints statically configured for a given scope.
 * 
 * @author Fabio Simeoni
 *
 */
public interface ServiceMap {

	/**
	 * Shared {@link ServiceMap}.
	 */
	public static final ServiceMap instance = new ScopedServiceMap();
	
	/**
	 * Returns the endpoints of a given service.
	 * @param service the service
	 * @return the endpoints, or <code>null</code> if the service is unknown.
	 */
	List<String> endpoint(String service);
	
	/**
	 * Returns the associated scope.
	 * @return the scope
	 */
	String scope();
}
