package org.gcube.common.scope.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;


/**
 * Adapts the JAXB-binding for {@link DefaultServiceMap}.
 * 
 * @author Fabio Simeoni
 *
 */
public class ServiceMapAdapter extends XmlAdapter<ServiceMapAdapter.ValueServiceMap,Map<String,List<String>>> {

	@XmlRootElement(name="services")
	static class ValueServiceMap {
		
		@XmlElement(name="service")
		Set<ServiceEntry> services;
		
	}
	
	static class ServiceEntry {
		
		@XmlAttribute
		private String name;
		
		@XmlElement(name="endpoint")
		private List<String> endpoints;
	}

	@Override
	public Map<String, List<String>> unmarshal(ValueServiceMap valueMap) throws Exception {
		Map<String, List<String>> map = new LinkedHashMap<String,List<String>>();
		for (ServiceEntry service : valueMap.services)
			map.put(service.name,service.endpoints);
		return map;
	}

	@Override
	public ValueServiceMap marshal(Map<String, List<String>> map) throws Exception {
		ValueServiceMap valueMap = new ValueServiceMap();
		for (Map.Entry<String,List<String>> e : map.entrySet()) {
			ServiceEntry entry = new ServiceEntry();
			entry.name=e.getKey();
			entry.endpoints = e.getValue();
		}
		return valueMap;
	}
}
