package org.gcube.common.resources.bindings;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.gcube.common.resources.DefaultResource;
import org.gcube.common.resources.Resource;
import org.gcube.common.resources.UntypedFacet;

/**
 * A facade over a {@link JAXBContext} that binds {@link Resource}s with {@link UntypedFacet}s.
 * 
 * @author Fabio Simeoni
 *
 */
public class UntypedResourceContext extends JAXBFacade {

	private static final JAXBContext context;

	static {

		try {

			// generic context knows only about generic resources
			context = JAXBContext
					.newInstance(DefaultResource.class);
			
		} catch (Exception e) {
			throw new RuntimeException("cannot configure resource bindings ", e);
		}
	}
	
	public static Unmarshaller unmarshaller() throws JAXBException {
		
		return unmarshaller(context);
		
	}
	
	public static Marshaller marshaller() throws JAXBException {
		return marshaller(context);
	}
	
}
