package org.gcube.common.resources.bindings;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;

import org.gcube.common.resources.Facet;
import org.gcube.common.resources.UntypedFacet;
import org.w3c.dom.Element;

/**
 * JAXB helper to converts between {@link Element}s and {@link UntypedFacet}s.
 * 
 * @author Fabio Simeoni
 *
 */
public class UntypedFacetAdapter extends XmlAdapter<Object,Facet> {

	@Override
	public Object marshal(Facet facet) throws Exception {
		if (facet instanceof UntypedFacet)
			return ((UntypedFacet) facet).data();
		else 
			return facet;
	}
	
	@Override
	public Facet unmarshal(Object object) throws Exception {
		if (object instanceof Facet)
			return ((Facet) object);
		else {
			Element e  = (Element) object;
			QName name = new QName(e.getNamespaceURI(),e.getLocalName());
			return new UntypedFacet(name,e);
		}
		
	}
}
