package org.gcube.common.resources.bindings;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import javax.xml.bind.Unmarshaller;

import org.gcube.common.resources.Resource;
import org.gcube.common.resources.ResourceFactory;

/**
 * Intercepts calls to {@link Unmarshaller} proxies in order to wrap unmarshalled {@link Resource}s.
 * 
 * @author Fabio Simeoni
 * @see ResourceWrapper
 *
 */
class UnmarshallerInterceptor implements InvocationHandler{

	private final Unmarshaller proxied;
	
	/**
	 * Creates an instance with a proxied unmarshaller.
	 * @param proxied the unmarshaller.
	 */
	public UnmarshallerInterceptor(Unmarshaller proxied) {
		this.proxied=proxied;
	}
	
	
	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		
		Object result = null;
		
		try{
			result = method.invoke(proxied, args);
		}
		catch(Exception e) { //unwraps reflective invocation exception
			throw e.getCause();
		}
		
		//implicitly recognise unmarhsal calls by their return values
		return result instanceof Resource?
				ResourceFactory.wrapResource((Resource) result):result;
		
	}
	
}
