package org.gcube.common.resources.bindings;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.common.resources.Resource;

/**
 * A {@link Resource} that wraps another {@link Resource}.
 * <p>
 * Used by {@link MarshallerInterceptor} to marshal the wrapped resource.
 * 
 * @author Fabio Simeoni
 * @see MarshallerInterceptor
 *
 */
public interface ResourceWrapper extends Resource {
	
	/**
	 * Marks the {@link ResourceWrapper#unwrap()} method to insulate reflective invocations from refactorings.
	 * @author Fabio Simeoni
	 *
	 */
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ElementType.METHOD})       
	public static @interface UnwrapMethod {}
	
	/**
	 * Returns the wrapped resource.
	 * @return
	 */
	@UnwrapMethod
	Resource unwrap();
}
