package org.gcube.common.resources.bindings;

import static org.scannotation.ClasspathUrlFinder.*;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.gcube.common.resources.DefaultResource;
import org.gcube.common.resources.Facet;
import org.gcube.common.resources.TypedFacet;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;

/**
 * A facade over a {@link JAXBContext} that binds {@link Facet} types found in classpath archives
 * that include a marker file {@link #resourcePath}.
 * 
 * @author Fabio Simeoni
 *
 */
public class ResourceContext extends JAXBFacade {

	public static final String resourcePath = "META-INF/facets.xml";

	private static final JAXBContext context;

	//scans classpath for bound facets
	static {

		try {

			// gather bound classes
			Set<Class<?>> bindings = new HashSet<Class<?>>();
			// resource is always bound
			bindings.add(DefaultResource.class);

			// find bindings in classpath
			ClassLoader loader = Thread.currentThread().getContextClassLoader();

			URL[] archives = findResourceBases(resourcePath, loader);
			ConfigurationBuilder b = new ConfigurationBuilder().addUrls(archives).addScanners(new SubTypesScanner());
			Reflections r = new Reflections(b);
			
			bindings.addAll(r.getSubTypesOf(TypedFacet.class));

			//create typed context
			context = JAXBContext.newInstance(bindings.toArray(new Class<?>[0]));
			
		} catch (Exception e) {
			throw new RuntimeException("cannot configure resource bindings ", e);
		}
	}
	
	public static Unmarshaller unmarshaller() throws JAXBException {
		
		return unmarshaller(context);
		
	}
	
	public static Marshaller marshaller() throws JAXBException {
		
		return marshaller(context);
		
	}
	
	
}
