package org.gcube.common.resources.bindings;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import javax.xml.bind.Marshaller;

import org.gcube.common.resources.Resource;

/**
 * Intercepts calls to {@link Marshaller} proxies in order to unwrap {@link ResourceWrapper} parameters
 * and marshal the underlying {@link Resource}s. 
 * 
 * @author Fabio Simeoni
 * @see ResourceWrapper
 *
 */
class MarshallerInterceptor implements InvocationHandler{

	private final Marshaller proxied;
	
	/**
	 * Creates an instance with a proxied marshaller.
	 * @param proxied the marshaller.
	 */
	public MarshallerInterceptor(Marshaller proxied) {
		this.proxied=proxied;
	}
	
	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		
		//recursively unwrap resource wrappers
		while (args[0] instanceof ResourceWrapper)
			args[0] = ((ResourceWrapper) args[0]).unwrap();
		
		try {
			return method.invoke(proxied, args);
		}
		catch(Exception e) { //unwraps reflective invocation exception
			throw e.getCause();
		}
		
	}
	
}
