package org.gcube.common.resources.bindings;

import java.lang.reflect.Proxy;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/**
 * Base class for facades to {@link JAXBContext}s.
 * 
 * @author Fabio Simeoni
 *
 */
class JAXBFacade {

	
	static Unmarshaller unmarshaller(JAXBContext ctxt) throws JAXBException {
		
		UnmarshallerInterceptor interceptor = new UnmarshallerInterceptor(ctxt.createUnmarshaller());
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		Class<?>[] interfaces = new Class<?>[]{Unmarshaller.class};
		return (Unmarshaller) Proxy.newProxyInstance(loader, interfaces, interceptor);
		
	}
	
	static Marshaller marshaller(JAXBContext ctxt) throws JAXBException {
		
		Marshaller m = ctxt.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);	
		
		MarshallerInterceptor interceptor = new MarshallerInterceptor(m);
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		Class<?>[] interfaces = new Class<?>[]{Marshaller.class};
		return (Marshaller) Proxy.newProxyInstance(loader, interfaces, interceptor);
		
	}
	
}
