package org.gcube.common.resources;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * A {@link Facet} with unbound {@link Element} data.
 * 
 * @author Fabio Simeoni
 *
 */
public final class UntypedFacet extends BaseFacet {

	private final Element data;
	
	/**
	 * Creates an instance with a given name and given data 
	 * @param name the name
	 * @param data the data
	 */
	public UntypedFacet(QName name, Element data) {
		super(name);
		this.data=data;
	}
	
	/**
	 * Returns the unbound data of the facet 
	 * @return the data
	 */
	public Element data() {
		return data;
	}
}
