package org.gcube.common.resources;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.gcube.common.resources.bindings.ResourceWrapper;
import org.gcube.common.resources.bindings.ResourceWrapper.UnwrapMethod;

/**
 * An interceptor of calls to {@link Resource} proxies.
 * 
 * @author Fabio Simeoni
 *
 */
public class ResourceInterceptor implements InvocationHandler  {

	static Method unwrapMethod;
	
	static {
		
		// determines the {@link ResourceWrapper#unwrap()} method to intercept
		for (Method m : ResourceWrapper.class.getMethods() )
			if (m.isAnnotationPresent(UnwrapMethod.class))
				unwrapMethod = m;
		
		if (unwrapMethod==null)
			throw new RuntimeException("could not find a proxied method on "+ResourceWrapper.class.getSimpleName());
	}
	
	private Resource proxied;
	
	/**
	 * Creates an instance with a proxied {@link Resource}. 
	 * @param proxied the resource
	 */
	public ResourceInterceptor(Resource proxied) {
		this.proxied=proxied;
	}
	
	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		
		//implements {@link ResourceWrapper}
		if (method.equals(unwrapMethod))
			return proxied;
		
		//implements equals correctly by symmetric invocation
		if(method.getName().equals("equals"))
			if (args[0]==null)
				return false;
			else 
				return args[0].equals(proxied);
				
		try {
			return method.invoke(proxied, args);
		}
		catch(Exception e) {
			//unwrap exception
			throw e.getCause();
		}
	}

}
