package org.gcube.common.resources;

import java.lang.reflect.Proxy;

import org.gcube.common.resources.bindings.ResourceWrapper;



/**
 * Creates {@link Resource}s.
 * 
 * @author Fabio Simeoni
 *
 */
public class ResourceFactory {

	//not meaningful yet
	
	/**
	 * Creates a {@link Resource}.
	 * @return the resource
	 */
	public static Resource newResource() {
		 
		 return resourceProxy(new DefaultResource());
		 
	}
	
	/**
	 * Wraps a {@link Resource}.
	 * @return the wrapped resource
	 */
	public static Resource wrapResource(Resource resource) {
		 
		return resourceProxy(resource);
		 
	}
	
	/**
	 * Wraps a {@link Resource}.
	 * @return the wrapped resource
	 */
	public static Resource resourceProxy(Resource resource) {
		 
		 ResourceInterceptor interceptor = new ResourceInterceptor(resource);
		 ClassLoader loader = Thread.currentThread().getContextClassLoader();
		 Class<?>[] interfaces = new Class<?>[]{ResourceWrapper.class};
		 return (Resource) Proxy.newProxyInstance(loader, interfaces, interceptor);
		 
	}
	
}
