/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.jaxws.handlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gcube.common.calls.Call;
import org.gcube.common.calls.Interceptors;
import org.gcube.common.calls.Request;
import org.gcube.common.calls.jaxws.GcubeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxWSHandler
implements SOAPHandler<SOAPMessageContext> {
    private Logger logger = LoggerFactory.getLogger(JaxWSHandler.class);
    protected GcubeService<?> context;

    public JaxWSHandler(GcubeService<?> context) {
        this.context = context;
    }

    public void close(MessageContext arg0) {
    }

    public boolean handleFault(SOAPMessageContext arg0) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outbound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        this.logger.trace("handling message");
        if (outbound.booleanValue()) {
            Request requestContext = Interceptors.executeRequestChain((Call)this.context.call());
            HashMap headers = (HashMap)messageContext.get((Object)"javax.xml.ws.http.request.headers");
            if (headers == null) {
                headers = new HashMap();
            }
            for (Map.Entry entry : requestContext.getHeaders()) {
                headers.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
            messageContext.put((Object)"javax.xml.ws.http.request.headers", headers);
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

