/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.jaxws;

import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import org.gcube.common.calls.jaxws.GcubeService;
import org.gcube.common.calls.jaxws.JaxWSEndpointReference;
import org.gcube.common.calls.jaxws.StubFactoryDSL;
import org.gcube.common.calls.jaxws.handlers.JaxWSHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubFactory<T>
implements StubFactoryDSL.AtClause<T> {
    private static Logger log = LoggerFactory.getLogger(StubFactory.class);
    private GcubeService<T> target;

    public static <T> StubFactory<T> stubFor(GcubeService<T> target) {
        return new StubFactory<T>(target);
    }

    private StubFactory(GcubeService<T> target) {
        this.target = target;
    }

    @Override
    public T at(String address) {
        try {
            String endpointAddress = address + "?wsdl";
            log.debug("contcting endpoint " + endpointAddress);
            Service service = Service.create((URL)new URL(endpointAddress), (QName)this.target.name());
            Object stub = service.getPort(this.target.type());
            BindingProvider provider = (BindingProvider)stub;
            this.registerHandler(provider, this.target);
            return (T)stub;
        }
        catch (Exception e) {
            log.error("error building service", (Throwable)e);
            throw new RuntimeException("error building service", e);
        }
    }

    public T at(EndpointReference endpoint) {
        return this.at(new JaxWSEndpointReference((EndpointReference)endpoint).address);
    }

    private void registerHandler(BindingProvider provider, GcubeService<?> context) {
        Binding binding = provider.getBinding();
        List currentChain = binding.getHandlerChain();
        JaxWSHandler handler = new JaxWSHandler(context);
        currentChain.add(handler);
        binding.setHandlerChain(currentChain);
    }
}

