package org.gcube.common.ghn.service.utils;




public class Utils {

	public static RuntimeException unchecked(Throwable t) {
		
		return (t instanceof RuntimeException)? RuntimeException.class.cast(t):new RuntimeException(t.getMessage(),t);
		
		
	}
	
	
	public static void valid(String name,Object[] o) throws IllegalArgumentException {
		notNull(name,o);
		
	}
	
	public static void notNull(Object[] o) throws IllegalArgumentException {
		notNull("argument",o);
	}
	
	public static void notNull(String name, Object o) throws IllegalArgumentException {
		if (o==null)
			throw new IllegalArgumentException(name+" is null");
	}
	
	public static void notEmpty(String name, String o) throws IllegalArgumentException {
		if (o.isEmpty())
			throw new IllegalArgumentException(name+" is empty");
	}
	
	public static void notEmpty(String name, Object[] o) throws IllegalArgumentException {
		if (o.length==0)
			throw new IllegalArgumentException(name+" is empty");
	}
	
	public static void valid(String name, String o) throws IllegalArgumentException {
		notNull(name, o);
		notEmpty(name,o);
	}
	
}
