package org.gcube.common.ghn.service.provider;

import static org.gcube.common.ghn.service.Constants.*;

import java.io.InputStream;

import javax.servlet.ServletContext;

import org.gcube.common.events.Hub;
import org.gcube.common.events.impl.DefaultHub;
import org.gcube.common.ghn.service.ApplicationManager;
import org.gcube.common.ghn.service.configuration.Configuration;
import org.gcube.common.ghn.service.configuration.ConfigurationBinder;
import org.gcube.common.ghn.service.configuration.Handlers;
import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.context.DefaultContext;
import org.gcube.common.ghn.service.context.Properties;
import org.gcube.common.ghn.service.lifecycle.DefaultLifecycle;
import org.gcube.common.ghn.service.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProvider implements Provider {

	private static Logger log = LoggerFactory.getLogger(ApplicationManager.class);
	
	public Configuration configuration(ServletContext application) {

		try {

			InputStream config = application.getResourceAsStream(configuration_file_path);
			
			if (config == null)
				throw new IllegalStateException("invalid application distribution: cannot find "
						+ configuration_file_path);

			ConfigurationBinder binder = new ConfigurationBinder();

			return binder.bind(config);

		} catch (RuntimeException e) {

			throw new RuntimeException("invalid configuration (see cause)", e);

		}
	}
	
	@Override
	public Handlers handlersFor(ApplicationContext context) {
		try {

			InputStream config = context.application().getResourceAsStream(handlers_file_path);

			if (config == null) {

				log.info("{}: uses the default lifecycle as it does not include {}", context.name(),
						handlers_file_path);

				// it's in a library, using
				config = getClass().getResourceAsStream(default_handlers_file_path);

				if (config == null)
					throw new IllegalStateException("invalid management library distribution: cannot find "
							+ default_handlers_file_path);

			} else
				log.info("{} uses a custom lifecycle @ {}", context.name(), handlers_file_path);

			ConfigurationBinder binder = new ConfigurationBinder();

			return binder.bindHandlers(config);
			
		} catch (RuntimeException e) {

			throw new RuntimeException("invalid gCube configuration for application @ " + context.name(), e);

		}
	}
	
	@Override
	public ApplicationContext contextFor(ServletContext application) {
		
		Configuration configuration = configuration(application);
		
		Hub hub = new DefaultHub();
		
		Lifecycle lifecycle = new DefaultLifecycle(hub,configuration.name());

		return new DefaultContext(application,configuration, hub, lifecycle, new Properties());
	}

}
