package org.gcube.common.ghn.service.persistence;

import static org.gcube.common.ghn.service.utils.Utils.*;

import java.io.File;

import javax.validation.constraints.NotNull;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="local-persistence")
public class LocalPersistence implements Persistence {

	@XmlAttribute(name="location")
	@NotNull
	private String location;
	
	public LocalPersistence() {}
	
	public LocalPersistence(String location) {
		this.location=location;
	}
	
	@Override
	public String location() {
		return location;
	}
	
	@Override
	public File file(String path) {
		
		notNull("relative path", path);
		
		return new File(location, path);
	}
	
	
	//called after JAXB unmarshalling to purge unavailable handlers
	void afterUnmarshal(Unmarshaller u, Object parent) {
		
		if (location==null)
			useDefaultLocation();
	}
	
	//helper
	private void useDefaultLocation() {
		
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((location == null) ? 0 : location.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LocalPersistence other = (LocalPersistence) obj;
		if (location == null) {
			if (other.location != null)
				return false;
		} else if (!location.equals(other.location))
			return false;
		return true;
	}
	
	
}
