package org.gcube.common.ghn.service.lifecycle;

import static java.util.Arrays.*;
import static java.util.Collections.*;

import java.util.List;

/**
 * The state and state transitions of the lifecycle of an application managed as a gCube service.
 * 
 * @author Fabio Simeoni
 *
 */
public enum State {
	
	/**
	 * The state of services that are in the process of initialisation.
	 */
	started(Lifecycle.started){
		
		public List<State> next() {
			return asList(ready, failed);
		}
	},

	/**
	 * The state of services that have completed initialisation and can accept client requests.
	 */
	ready(Lifecycle.ready) {

		public List<State> next() {
			return asList(failed,stopped);
		}
	},
	
	/**
	 * The state of services that have can no longer accept requests, even though they may in the future.
	 */
	stopped(Lifecycle.stopped){
		
		public List<State> next() {
			return asList(failed,ready);
		}
	},

	/**
	 * The permanent state of services that can no longer accept requests.
	 */
	failed(Lifecycle.failed){

		public List<State> next() {
			return emptyList();
		}
	};

	private final String event;
	
	//used internally
	State(String event) {
		this.event=event;
	}
	
	
	/**
	 * Returns the list of states to which services can transition to from this state.
	 * @return the states
	 */
	public abstract List<State> next();
	
	/**
	 * Returns the event corresponding to this state.
	 * @return the 
	 */
	String event() {
		return event;
	}
	
	/**
	 * Returns a serialisation of this state for exchange purposes.
	 * @return
	 */
	public String remoteForm() {
		return event;
	}
}
