package org.gcube.common.ghn.service.lifecycle;

/**
 * The lifecycle of an application managed as a gCube service.
 * 
 * @author Fabio Simeoni
 *
 */
public interface Lifecycle {

	/**
	 * The event qualifier that correspond to the {@link #started} state of the service lifecycle.
	 */
	public static final String started = "started";
	
	/**
	 * The event qualifier that correspond to the {@link #ready} state of the service lifecycle.
	 */
	public static final String ready = "ready";
	
	/**
	 * The event qualifier that correspond to the {@link #stopped} state of the service lifecycle.
	 */
	public static final String stopped = "stopped";
	
	/**
	 * The event qualifier that correspond to the {@link #failed} state of the service lifecycle.
	 */
	public static final String failed = "failed";
	
	
	
	
	/**
	 * Returns the state from which this lifecycle transitioned to its current state.
	 * @return the previous state
	 */
	State previous();
	
	/**
	 * Returns the current state of this lifecycle.
	 * @return the current state.
	 */
	State state();
	
	/**
	 * Transition this lifecycle to a given state.
	 * @param state the state
	 * 
	 * @throws IllegalStateException if the transition is illegal for this lifecycle 
	 */
	void moveTo(State state);
	
	
	/**
	 * Attempts to transition this lifecycle to a given state, but does not fail if the transition is illegal for this lifecycle.
	 * @param state the state
	 */
	void tryMoveTo(State state);
	
}
