package org.gcube.common.ghn.service.lifecycle;

import org.gcube.common.events.Hub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycle implements Lifecycle {

	private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);
	
	private final Hub hub;
	private final String name;
	private State currentState;
	private State previousState;
	
	public DefaultLifecycle(Hub hub, String name){
		this.hub = hub;
		this.currentState = State.started;
		this.name = name;
	}
	
	@Override
	public State state() {
		return currentState;
	}

	@Override
	public void moveTo(State next) {
		
		if (next == currentState) 
			return;
		
		if (currentState.next().contains(next)){

			this.previousState = this.currentState;
			this.currentState = next;
			
			log.info("application @ {} transitioned from {} to {}",new Object[]{name,previousState,currentState});
			
			hub.fire(this, currentState.event());
			
		}
		else throw new IllegalStateException("cannot transition application @ "+name+" from " +currentState+" to "+next);
			
	}
	
	@Override
	public void tryMoveTo(State next) {
		try {
			moveTo(next);
		}
		catch(IllegalStateException ignore) {
			log.warn(ignore.getMessage());
		}
		
	}

	public State previous() {
		return this.previousState;
	}

}
