package org.gcube.common.ghn.service.handlers.request;

import static org.gcube.common.ghn.service.Constants.*;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

import org.gcube.common.ghn.service.Constants;
import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.events.RequestEvent;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name = Constants.scope_management)
public class ScopeHandler extends RequestHandler {

	/** Namespace of scope-related headers */
	protected static final String SCOPE_NS = "http://gcube-system.org/namespaces/scope";

	/** Name of the scope call header. */
	protected static final String SCOPE_HEADER_NAME = "scope";
	protected static final QName SCOPE_QNAME = new QName(SCOPE_NS, SCOPE_HEADER_NAME);

	private static Logger log = LoggerFactory.getLogger(ScopeHandler.class);

	@Override
	public void handleRequest(RequestEvent event) {

		ApplicationContext context = event.context();
		
		String scope = scopeFromHttpHeader(event);

		GCoreEndpoint endpoint = context.properties().lookup(Constants.profile_property).value(GCoreEndpoint.class);
		
		valid(endpoint,scope);
		
		log.trace("extracted scope {} from request {} to application {}",new Object[]{scope,event.uri(),context.name()});
		
		ScopeProvider.instance.set(scope);
		
	}

	// helper
	private String scopeFromHttpHeader(RequestEvent e) {

		String scope = e.request().getHeader(scope_header);
		
		if (scope == null)
			throw new RuntimeException("call to "+e.uri()+" is unscoped"); 
		
		return scope;
	}
	
	
	private void valid(GCoreEndpoint endpoint, String scope) {

		//TODO validate scope
		
//		@SuppressWarnings("unchecked")
//		List<String> scopes = (List<String>)e.servletContext().getAttribute(Constants.scopes_context_attibute);
//		if (scopes.contains(scope))
//			ScopeProvider.instance.set(scope);
//		else 
//			throw new ScopeNotAllowedException(scope+" not supported");
		
	}
}
