package org.gcube.common.ghn.service.handlers.lifecycle;

import static org.gcube.common.ghn.service.Constants.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;

import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.common.ghn.service.Constants;
import org.gcube.common.ghn.service.configuration.Configuration;
import org.gcube.common.ghn.service.configuration.Mode;
import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.context.Property;
import org.gcube.common.ghn.service.events.LifecycleEvent;
import org.gcube.common.ghn.service.handlers.LifecycleHandler;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name = Constants.publish_services)
public class Publisher extends LifecycleHandler {

	Logger log = LoggerFactory.getLogger(Publisher.class);

	private RegistryPublisher registryPublisher = RegistryPublisherFactory.create();

	private GCoreEndpoint endpoint;
	private ApplicationContext context;

	public void registryPublisher(RegistryPublisher registryPublisher) {
		this.registryPublisher = registryPublisher;
	}

	@Override
	public void onStart(LifecycleEvent.Start e) {

		context = e.context();

		endpoint = createOrRetrieveProfile();

		;

		storeProfile();

		// configuration.hub().subscribe(new Object() {
		// @Observes @SuppressWarnings("unused")
		// void onChange() {
		// storeProfile();
		// }
		// });
		//
		// configuration.hub().fire(endpoint,endpointChanged);

		context.properties().add(new Property(profile_property, endpoint));

		publishProfile(context.configuration(), endpoint);
	}

	// helpers

	private void publishProfile(Configuration configuration, GCoreEndpoint endpoint) {

		for (String scope : configuration.startScopes()) {

			ScopeProvider.instance.set(scope);

			if (configuration.mode() == Mode.online)
				endpoint = registryPublisher.create(endpoint);

			log.info("published endpoint profile of application {} in scope {}", configuration.name(), scope);
		}
	}

	private GCoreEndpoint createOrRetrieveProfile() {

		File file = context.configuration().persistence().file(profile_file_name);

		return file.exists() ? loadProfile(file) : createProfile();
	}

	private GCoreEndpoint createProfile() {

		Configuration configuration = context.configuration();

		log.info("creating endpoint profile for {}", context.name());

		GCoreEndpoint endpoint = new GCoreEndpoint();
		
		try {

			endpoint.profile().description(configuration.description()).serviceName(configuration.name())
					.serviceClass(configuration.serviceClass()).version(configuration.version())
					.serviceId(configuration.name() + configuration.serviceClass() + configuration.version());

			endpoint.profile().newDeploymentData().activationTime(Calendar.getInstance()).status("READY");

			// TODO: retrieve AccessPoint for webApp
			/*
			 * for (AccessPoint accessPoint : profile.accessPoints())
			 * instance.profile().endpoints().add().nameAndAddress(accessPoint.name(),
			 * URI.create(accessPoint.endpoint()));
			 */
			//endpoint.profile().ghnId(InetAddress.getLocalHost().getHostAddress());
			
			endpoint.profile().ghnId("fakeId");
			
			
		} catch (Throwable e) {
			
			throw new RuntimeException("cannot retrieve endpoint profile for " + context.name(), e);
			
		}
		
		return endpoint;
	}

	private GCoreEndpoint loadProfile(File file) {

		try {

			log.info("retrieving endpoint profile for {} from {}", context.name(), file.getAbsolutePath());

			return Resources.unmarshal(GCoreEndpoint.class, new FileInputStream(file));

		} catch (Throwable e) {
			
			throw new RuntimeException("cannot retrieve endpoint profile for " + context.name(), e);

		}

	}

	private void storeProfile() {

		File file = context.persistence().file(profile_file_name);

		try {

			log.info("storing endpoint profile for {} from {}", context.name(), file.getAbsolutePath());

			Resources.marshal(endpoint, new FileOutputStream(file));
		} catch (Exception e) {
			throw new RuntimeException("cannot store endpoint profile for " + context.name() + " in "
					+ file.getAbsolutePath());
		}
	}

}
