package org.gcube.common.ghn.service.handlers;

import java.util.logging.Handler;

import org.gcube.common.ghn.service.events.ApplicationEvent;
import org.gcube.common.ghn.service.events.LifecycleEvent;

/**
 * A {@link Handler} of {@link LifecycleEvent}s.
 * <p>
 * The handler participates in a {@link Pipeline} of other handlers registered for notification of the same events.
 * After processing the event, it may or may not propagate the event to the handlers further down in the {@link Pipeline}
 * {@link Pipeline#forward(ApplicationEvent)}.
 * @author Fabio Simeoni
 *
 * @see LifecycleEvent
 * @see Pipeline
 */
public abstract class LifecycleHandler extends AbstractHandler<LifecycleHandler> {
	
	
	/**
	 * Invoked when the container starts a managed app.
	 * @param pipeline the pipeline in which this handler is registered
	 * @param e the event
	 */
	public void onStart(LifecycleEvent.Start e) {
	
	}

	/**
	 * Invoked when the container stops a managed app.
	 * @param pipeline the pipeline in which this handler is registered
	 * @param e the stop event
	 */
	public void onStop(LifecycleEvent.Stop e) {
	}
	
	@Override
	public void onEvent(ApplicationEvent<LifecycleHandler> e) {
		
		if (e instanceof LifecycleEvent.Start)
			onStart(LifecycleEvent.Start.class.cast(e));
		else
			if (e instanceof LifecycleEvent.Stop)
				onStop(LifecycleEvent.Stop.class.cast(e));
	}
}
