package org.gcube.common.ghn.service.handlers;

import org.gcube.common.ghn.service.events.ApplicationEvent;

/**
 * Handles {@link ApplicationEvent}s.
 * 
 * @author Fabio Simeoni
 * 
 * @param <T> the (recursive) type of the handler.
 * 
 * @see ApplicationEvent
 */
public interface ApplicationHandler<T extends ApplicationHandler<T>> {

	/**
	 * Processes a given event.
	 * 
	 * @param pipeline the pipeline in which the handler is registered.
	 * @param e the event
	 */
	void onEvent(ApplicationEvent<T> e);


}
