package org.gcube.common.ghn.service.events;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.common.ghn.service.context.ApplicationContext;

/**
 * A {@link ApplicationEvent} that occurs when the application returns a response to a given request.
 
 * @author Fabio Simeoni
 * 
 */
public class ResponseEvent extends RequestEvent {

	private final HttpServletResponse response;

	/**
	 * Creates an instance with the name of the target servlet, the context of the application, the client request, and the application response.
	 * 
	 * @param servlet the name of the servlet
	 * @param context the context of the application
	 * @param request the request
	 * @param response the response
	 */
	public ResponseEvent(String servlet, ApplicationContext context, HttpServletRequest request, HttpServletResponse response) {
		super(servlet, context, request);
		this.response = response;
	}

	/**
	 * Returns the response.
	 * 
	 * @return the response
	 */
	public HttpServletResponse response() {
		return response;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[req=" + request().getRemoteHost() + ",resp="
				+ response.toString().substring(0, 12) + "]";
	}
}
