package org.gcube.common.ghn.service.events;

import javax.servlet.http.HttpServletRequest;

import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.handlers.RequestHandler;

/**
 * An {@link ApplicationEvent} that occurs when a request reaches a servlet of the application.
 * 
 * @author Fabio Simeoni
 * 
 */
public class RequestEvent extends ApplicationEvent<RequestHandler> {

	private final String servlet;
	private final HttpServletRequest request;

	
	/**
	 * Creates an instance with the application context, the client request, and the name of the target servlet.
	 * 
	 * @param context the context of the application
	 * @param servlet the name of the target servlet
	 * @param request the client request
	 */
	public RequestEvent(String servlet,ApplicationContext context, HttpServletRequest request) {
		super(context);
		this.request = request;
		this.servlet = servlet;
	}

	/**
	 * Returns the name of the target servlet.
	 * 
	 * @return the name of the servlet.
	 */
	public String servlet() {
		return servlet;
	}

	public String uri() {
		String query = request().getQueryString();
		return query==null?request().getRequestURI():request().getRequestURI()+"?"+query;
	}
	
	/**
	 * Returns the client request.
	 * 
	 * @return the request
	 */
	public HttpServletRequest request() {
		return request;
	}
}
