package org.gcube.common.ghn.service.events;

import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.handlers.LifecycleHandler;

/**
 * An {@link ApplicationEvent} that occurs when the application starts or shuts down.
 
 * @author Fabio Simeoni
 * 
 */
public abstract class LifecycleEvent extends ApplicationEvent<LifecycleHandler> {

	/**
	 * An {@link ApplicationEvent} that occurs when the application starts.
	 */
	public static class Start extends LifecycleEvent {
	
		/**
		 * Creates an instance for a given {@link ApplicationContext}.
		 * @param context the context
		 */
		public Start(ApplicationContext context) {
			super(context);
		}
	}
	
	/**
	 * An {@link ApplicationEvent} that occurs when the application stops.
	 */
	public static class Stop extends LifecycleEvent {
		
		/**
		 * Creates an instance for a given {@link ApplicationContext}.
		 * @param context the context
		 */
		public Stop(ApplicationContext context) {
			super(context);
		}
	}
	
	/**
	 * Creates an instance for a given {@link ApplicationContext}.
	 * @param context the context
	 */
	LifecycleEvent(ApplicationContext context) {
		super(context);
	}
	
}