package org.gcube.common.ghn.service.events;

import org.gcube.common.ghn.service.context.ApplicationContext;
import org.gcube.common.ghn.service.handlers.ApplicationHandler;

/**
 * An event that occurs in the lifetime of the application.
 
 * @author Fabio Simeoni
 * 
 */
public abstract class ApplicationEvent<T extends ApplicationHandler<T>> {

	private final ApplicationContext context;
	
	/**
	 * Creates an instance for a given {@link ApplicationContext}.
	 * @param context the context
	 */
	ApplicationEvent(ApplicationContext context) {
		this.context=context;
	}
	
	/**
	 * Returns the context of the application.
	 * @return the context
	 */
	public ApplicationContext context() {
		return context;
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName();
	}
}
