package org.gcube.common.ghn.service.context;

import javax.servlet.ServletContext;

import org.gcube.common.events.Hub;
import org.gcube.common.ghn.service.configuration.Configuration;
import org.gcube.common.ghn.service.lifecycle.Lifecycle;
import org.gcube.common.ghn.service.persistence.Persistence;

public class DefaultContext implements ApplicationContext {

	private final ServletContext sctx; 
	private final Configuration configuration;
	private final Lifecycle lifecycle;
	private final Properties properties;
	private final Hub hub;
	
	public DefaultContext(ServletContext sctx,Configuration configuration, Hub hub, Lifecycle lifecycle, Properties properties) {
		this.sctx = sctx;
		this.configuration=configuration;
		this.hub=hub;
		this.lifecycle = lifecycle;
		this.properties=properties;
	}
	
	public DefaultContext(ApplicationContext ctx) {
		this(ctx.application(),ctx.configuration(),ctx.events(), ctx.lifecycle(), new Properties(ctx.properties()));
	}
	
	@Override
	public ServletContext application() {
		return sctx;
	}
	
	@Override
	public String name() { //little shortcut for ease of logging
		return configuration.name();
	}

	@Override
	public Configuration configuration() {
		return configuration;
	}

	@Override
	public Lifecycle lifecycle() {
		return lifecycle;
	}

	@Override
	public Hub events() {
		return hub;
	}

	@Override
	public Persistence persistence() {
		return configuration.persistence();
	}

	@Override
	public Properties properties() {
		return properties;
	}

	
}
