package org.gcube.common.ghn.service.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.common.ghn.service.handlers.ApplicationHandler;
import org.gcube.common.ghn.service.handlers.LifecycleHandler;
import org.gcube.common.ghn.service.handlers.RequestHandler;

/**
 * The {@link ApplicationHandler}s that manage the application.
 *  
 * @author Fabio Simeoni
 *
 */
@XmlRootElement(name="handlers")
public class Handlers {
	
	@XmlElement(name="lifecycle")
	private LifecycleHandlers lifetimeHandlers = new LifecycleHandlers();
	
	@XmlElement(name="request")
	private RequestHandlers requestHandlers = new RequestHandlers();
	
	public Handlers() {}
	
	/**
	 * Returns the {@link LifecycleHandler}s for the service.
	 * @return the lifecycle handlers
	 */
	public List<LifecycleHandler> lifecycleHandlers() {
		return lifetimeHandlers.values;
	}
	
	/**
	 * Sets the {@link LifecycleHandler}s for the service.
	 * @param handlers the lifecycle handlers
	 * @return this configuration
	 */
	public Handlers set(LifecycleHandler ... handlers) {
		this.lifetimeHandlers = new LifecycleHandlers(Arrays.asList(handlers));
		return this;
	}
	
	/**
	 * Returns the {@link RequestHandler}s for the service.
	 * @return the lifetime handlers
	 */
	public List<RequestHandler> requestHandlers() {
		return requestHandlers.values;
	}
	
	/**
	 * Sets the {@link RequestHandler}s for the service.
	 * @param handlers the request handlers
	 * @return this configuration
	 */
	public Handlers set(RequestHandler ... handlers) {
		this.requestHandlers = new RequestHandlers(Arrays.asList(handlers));
		return this;
	}
	
   //////////////// HELPER BINDING CLASSES
   
   //used internally to introduce level of nesting in JAXB whilst preserving arbitrary extension
 	
    private static class LifecycleHandlers {
 	
 		@SuppressWarnings("all")
 		LifecycleHandlers() { //needed for deserialisation
 		}
 		
 		LifecycleHandlers(List<LifecycleHandler> handlers) {
 			this.values=handlers;
 		}
 		
 		@XmlAnyElement(lax=true)
 		List<LifecycleHandler> values = new ArrayList<LifecycleHandler>();
 		
 	}
 	
 	//used internally to introduce level of nesting in JAXB whilst preserving arbitrary extension
 	private static class RequestHandlers {
 	
 		@SuppressWarnings("all")
 		RequestHandlers() { //needed for deserialisation
 		}
 		
 		RequestHandlers(List<RequestHandler> handlers) {
 			this.values=handlers;
 		}
 		
 		@XmlAnyElement(lax=true)
 		List<RequestHandler> values = new ArrayList<RequestHandler>();
 		
 	}
   
}