package org.gcube.common.ghn.service;

import org.gcube.common.ghn.service.handlers.lifecycle.Publisher;
import org.gcube.common.ghn.service.handlers.request.ScopeHandler;

/**
 * Library-wide constants.
 * 
 * 
 * @author Fabio Simeoni
 *
 */
public class Constants {

	/**
	 * The configuration file path..
	 */
	public static final String configuration_file_path = "/WEB-INF/gcube-app.xml";
	
	/**
	 * The lifecycle configuration file path.
	 */
	public static final String handlers_file_path = "/WEB-INF/gcube-handlers.xml";
	
	/**
	 * The default lifecycle configuration file path.
	 */
	public static final String default_handlers_file_path = "/META-INF/default-handlers.xml";
	
	/**
	 * The configuration name of {@link Publisher}s.
	 */
	public static final String publish_services = "publishing-services"; 
	
	/**
	 * The configuration name of {@link ScopeHandler}s.
	 */
	public static final String scope_management = "scope-management"; 
	
	/**
	 * The configuration file name.
	 */
	public static final String profile_file_name = "endpoint.xml";
	
	/**
	 * The name of the property that contains the endpoint profile.
	 */
	public static final String profile_property = "endpoint-profile"; 
	
	
	public static final String scope_header="Gcube-Scope";
	
	
	//event qualifiers
	public static final String serviceFailure="fail";
	
	public static final String endpointChanged="fail";
}
