package org.gcube.common.ghn.service;

import java.util.Set;

import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/**
 * Adds a {@link ApplicationListener} to managed services.
 * <p>
 * It is automatically discovered from a app library or a shared library in servlet containers that comply with
 * version 3.0 or later of the Servlet specifications.
 * 
 * @author Fabio Simeoni
 * 
 */
public class ApplicationInitializer implements ServletContainerInitializer {

	@Override
	public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {

		//pass through for non managed services
		if (isManagedService(ctx))
			// register app listener
			ctx.addListener(new ApplicationListener());
	}

	private boolean isManagedService(ServletContext ctx) {
		return ctx.getResourceAsStream("/" + Constants.configuration_file_path) != null;
	}

}
